<?php include 'header.php'; ?>
<style>
.rentalsmmpanelbd-container {
    padding: 20px;
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
    gap: 20px;
    max-width: auto;
    margin: 0 auto;
}
.rentalsmmpanelbd-panel {
    background: white;
    border-radius: 12px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
    transition: all 0.3s ease;
    overflow: hidden;
    display: flex;
    flex-direction: column;
    height: 100%;
}
.rentalsmmpanelbd-panel:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 24px rgba(0, 0, 0, 0.12);
}
.rentalsmmpanelbd-panel-heading {
    padding: 20px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    position: relative;
}
.rentalsmmpanelbd-panel-heading::after {
    content: '';
    position: absolute;
    top: -50%;
    right: -50%;
    width: 100%;
    height: 200%;
    background: rgba(255, 255, 255, 0.1);
    transform: rotate(30deg);
}
.rentalsmmpanelbd-panel-footer {
    background: #cfe7ff;
    padding: 15px 20px;
    border-top: 1px solid #f1f5f9;
    margin-top: auto;
    transition: all 0.3s ease;
}
.rentalsmmpanelbd-panel:hover .rentalsmmpanelbd-panel-footer {
    background: #f1f5f9;
}
.rentalsmmpanelbd-panel a {
    text-decoration: none;
    color: inherit;
    display: flex;
    flex-direction: column;
    height: 100%;
}
.rentalsmmpanelbd-panel .panel-row {
    display: flex;
    align-items: center;
    justify-content: space-between;
}
.rentalsmmpanelbd-panel .panel-icon {
    width: 60px;
    height: 60px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 12px;
}
.rentalsmmpanelbd-panel .panel-content {
    text-align: right;
}
.rentalsmmpanelbd-panel .huge {
    font-size: 32px;
    font-weight: 700;
    line-height: 1;
    margin-bottom: 5px;
    font-family: 'Inter', sans-serif;
}
.rentalsmmpanelbd-panel h5 {
    font-size: 14px;
    opacity: 0.9;
    margin: 0;
    font-weight: 500;
}
.rentalsmmpanelbd-panel-footer span {
    font-size: 13px;
    color: #64748b;
    transition: all 0.3s ease;
}
.rentalsmmpanelbd-panel:hover .rentalsmmpanelbd-panel-footer span {
    color: #334155;
}
.rentalsmmpanelbd-panel-footer .fa-arrow-circle-right {
    color: #6366f1;
    transition: all 0.3s ease;
}
.rentalsmmpanelbd-panel:hover .rentalsmmpanelbd-panel-footer .fa-arrow-circle-right {
    transform: translateX(3px);
}
.rentalsmmpanelbd-panel:nth-child(1) .rentalsmmpanelbd-panel-heading {
    background: linear-gradient(135deg, #4f46e5 0%, #7c3aed 100%);
}
.rentalsmmpanelbd-panel:nth-child(2) .rentalsmmpanelbd-panel-heading {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
}
.rentalsmmpanelbd-panel:nth-child(3) .rentalsmmpanelbd-panel-heading {
    background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
}
.rentalsmmpanelbd-panel:nth-child(4) .rentalsmmpanelbd-panel-heading {
    background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
}
.rentalsmmpanelbd-panel:nth-child(5) .rentalsmmpanelbd-panel-heading {
    background: linear-gradient(135deg, #06b6d4 0%, #0e7490 100%);
}
.rentalsmmpanelbd-panel:nth-child(6) .rentalsmmpanelbd-panel-heading {
    background: linear-gradient(135deg, #8b5cf6 0%, #7e22ce 100%);
}
.rentalsmmpanelbd-panel:nth-child(7) .rentalsmmpanelbd-panel-heading {
    background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
}
.rentalsmmpanelbd-panel:nth-child(8) .rentalsmmpanelbd-panel-heading {
    background: linear-gradient(135deg, #14b8a6 0%, #0d9488 100%);
}
.rentalsmmpanelbd-panel:nth-child(9) .rentalsmmpanelbd-panel-heading {
    background: linear-gradient(135deg, #f97316 0%, #ea580c 100%);
}
.rentalsmmpanelbd-panel:nth-child(10) .rentalsmmpanelbd-panel-heading {
    background: linear-gradient(135deg, #84cc16 0%, #65a30d 100%);
}
.rentalsmmpanelbd-panel:nth-child(11) .rentalsmmpanelbd-panel-heading {
    background: linear-gradient(135deg, #0ea5e9 0%, #0369a1 100%);
}
.rentalsmmpanelbd-panel:nth-child(12) .rentalsmmpanelbd-panel-heading {
    background: linear-gradient(135deg, #d946ef 0%, #a21caf 100%);
}
@media (max-width: 768px) {
    .rentalsmmpanelbd-container {
        grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
    }
}
@media (max-width: 480px) {
    .rentalsmmpanelbd-container {
        grid-template-columns: 1fr;
    }
}
.rentalsmmpanelbd-chart-container {
    background: white;
    border-radius: 12px;
    padding: 20px;
    margin-top: 20px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
    width: 100%;
}
.rentalsmmpanelbd-chart-container h3 {
    margin-bottom: 20px;
    color: #1e293b;
    font-weight: 600;
    font-size: 18px;
}
 .rentalsmmpanelbd-2fa-container {
        padding: 2rem;
        font-family: sans-serif;
    }

    .rentalsmmpanelbd-2fa-alert {
        border-radius: 8px;
        padding: 1.5rem;
        text-align: center;
    }

    .rentalsmmpanelbd-2fa-alert-heading {
        font-size: 1.25rem;
        font-weight: 600;
        margin-top: 0;
        margin-bottom: 0.5rem;
    }

    .rentalsmmpanelbd-2fa-alert p {
        margin-bottom: 1.5rem;
        color: #4b5563;
        line-height: 1.6;
    }

    .rentalsmmpanelbd-2fa-alert-success {
        background-color: #f0fdf4;
        border-left: 5px solid #22c55e;
    }

    .rentalsmmpanelbd-2fa-alert-success .rentalsmmpanelbd-2fa-alert-heading {
        color: #166534;
    }

    .rentalsmmpanelbd-2fa-alert-warning {
        background-color: #fffbeb;
        border-left: 5px solid #f59e0b;
    }

    .rentalsmmpanelbd-2fa-alert-warning .rentalsmmpanelbd-2fa-alert-heading {
        color: #92400e;
    }

    .rentalsmmpanelbd-2fa-btn {
        display: inline-block;
        text-decoration: none;
        border: none;
        border-radius: 8px;
        padding: 0.75rem 1.5rem;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.2s ease-in-out;
        box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px -1px rgba(0, 0, 0, 0.1);
    }

    .rentalsmmpanelbd-2fa-btn-danger {
        background-color: #ef4444;
        color: white;
    }

    .rentalsmmpanelbd-2fa-btn-danger:hover {
        background-color: #dc2626;
        transform: translateY(-2px);
    }

    .rentalsmmpanelbd-2fa-btn-primary {
        background-color: #ff904d;
        color: white !important;
    }

    .rentalsmmpanelbd-2fa-btn-primary:hover {
        background-color: #bdcdef;
        color: #777 !important;
        transform: translateY(-2px);
    }

    @media (max-width: 768px) {
        .rentalsmmpanelbd-2fa-container {
            padding: 1.5rem;
        }
        .rentalsmmpanelbd-2fa-title {
            font-size: 1.25em;
        }
        .rentalsmmpanelbd-2fa-alert-heading {
            font-size: 1.1rem;
        }
        .rentalsmmpanelbd-2fa-btn {
            width: 100%;
            padding: 1rem;
        }
    }
</style>

<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

<?php
if ( $_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['two_factor']) ) {
    if ( !empty($_SESSION["msmbilisim_adminid"]) ) {
        
        $admin_id = $_SESSION["msmbilisim_adminid"];
        $new_status = $_POST['two_factor'];
        if ($new_status == '0') {
            $update_query = $conn->prepare(
                "UPDATE admins 
                 SET two_factor = :status, two_factor_secret_key = :secret 
                 WHERE admin_id = :id"
            );
            $update_query->execute([
                'status' => 0,
                'secret' => null,
                'id'     => $admin_id
            ]);
            header('Location: ' . site_url('admin'));
            exit();
        }
    }
}
?>

<div class="rentalsmmpanelbd-2fa-container">
    <?php if (isset($admin["two_factor"]) && $admin["two_factor"] == '1'): ?>
        <!-- Case 1: 2FA is already ON -->
        <div class="rentalsmmpanelbd-2fa-alert rentalsmmpanelbd-2fa-alert-success">
            <h4 class="rentalsmmpanelbd-2fa-alert-heading">2FA is Active <i class="fa-regular fa-circle-check"></i></h4>
            <p>Your account is protected by Two-Factor Authentication. Your panel is secure.</p>
            <form action="/admin" method="post">
                <input type="hidden" name="two_factor" value="0">
                <button type="submit" class="rentalsmmpanelbd-2fa-btn rentalsmmpanelbd-2fa-btn-danger">Turn Off 2FA</button>
            </form>
        </div>

    <?php else: ?>

        <!-- Case 2: 2FA is OFF -->
        <div class="rentalsmmpanelbd-2fa-alert rentalsmmpanelbd-2fa-alert-warning">
            <h4 class="rentalsmmpanelbd-2fa-alert-heading">Secure Your Account! <i class="fa-solid fa-triangle-exclamation"></i></h4>
            <p>Enable Two-Factor Authentication (2FA) to add an extra layer of security to your account, helping to protect your personal information and prevent unauthorized access..</p>
            <a href="/admin/activate-google-2fa" class="rentalsmmpanelbd-2fa-btn rentalsmmpanelbd-2fa-btn-primary">Enable Two-Factor</a>
        </div>

    <?php endif; ?>
</div>

<div class="rentalsmmpanelbd-container">
    <!-- Total Users Panel -->
    <div class="rentalsmmpanelbd-panel">
        <div class="rentalsmmpanelbd-panel-heading">
            <div class="panel-row">
                <div class="panel-icon">
                    <i class="fas fa-users fa-2x" style="color: white;"></i>
                </div>
                <div class="panel-content">
                    <div class="huge"><?php echo countRow(["table"=>"clients"]); ?></div>
                    <h5>Total Users</h5>
                </div>
            </div>
        </div>
        <a href="/admin/clients">
            <div class="rentalsmmpanelbd-panel-footer">
                <span class="pull-left">View Details</span>
                <span class="pull-right"><i class="fas fa-arrow-circle-right"></i></span>
                <div class="clearfix"></div>
            </div>
        </a>
    </div>
    
    <!-- Total Orders Panel -->
    <div class="rentalsmmpanelbd-panel">
        <div class="rentalsmmpanelbd-panel-heading">
            <div class="panel-row">
                <div class="panel-icon">
                    <i class="fas fa-shopping-cart fa-2x" style="color: white;"></i>
                </div>
                <div class="panel-content">
                    <div class="huge"><?php echo countRow(["table"=>"orders"]) ?></div>
                    <h5>Total Orders</h5>
                </div>
            </div>
        </div>
        <a href="/admin/orders">
            <div class="rentalsmmpanelbd-panel-footer">
                <span class="pull-left">View Details</span>
                <span class="pull-right"><i class="fas fa-arrow-circle-right"></i></span>
                <div class="clearfix"></div>
            </div>
        </a>
    </div>
    
    <!-- Refilling Orders Panel -->
    <div class="rentalsmmpanelbd-panel">
        <div class="rentalsmmpanelbd-panel-heading">
            <div class="panel-row">
                <div class="panel-icon">
                    <i class="fas fa-sync-alt fa-2x" style="color: white;"></i>
                </div>
                <div class="panel-content">
                    <div class="huge"><?php echo countRow(["table"=>"tasks"]) ?></div>
                    <h5>Refilling Orders</h5>
                </div>
            </div>
        </div>
        <a href="/admin/tasks">
            <div class="rentalsmmpanelbd-panel-footer">
                <span class="pull-left">View Details</span>
                <span class="pull-right"><i class="fas fa-arrow-circle-right"></i></span>
                <div class="clearfix"></div>
            </div>
        </a>
    </div>
    
    <!-- Unread Tickets Panel -->
    <div class="rentalsmmpanelbd-panel">
        <div class="rentalsmmpanelbd-panel-heading">
            <div class="panel-row">
                <div class="panel-icon">
                    <i class="fas fa-ticket-alt fa-2x" style="color: white;"></i>
                </div>
                <div class="panel-content">
                    <div class="huge"><?php echo countRow(["table"=>"tickets","where"=>["client_new"=>2]]) ?></div>
                    <h5>Unread Tickets</h5>
                </div>
            </div>
        </div>
        <a href="/admin/tickets">
            <div class="rentalsmmpanelbd-panel-footer">
                <span class="pull-left">View Details</span>
                <span class="pull-right"><i class="fas fa-arrow-circle-right"></i></span>
                <div class="clearfix"></div>
            </div>
        </a>
    </div>
    
    <!-- Received Payments Panel -->
    <div class="rentalsmmpanelbd-panel">
        <div class="rentalsmmpanelbd-panel-heading">
            <div class="panel-row">
                <div class="panel-icon">
                    <i class="fas fa-money-bill-wave fa-2x" style="color: white;"></i>
                </div>
                <div class="panel-content">
                    <div class="huge"><?php echo countRow(["table"=>"payments","where"=>["payment_status"=>3]]) ?></div>
                    <h5>Received Payments</h5>
                </div>
            </div>
        </div>
        <a href="/admin/fund-add-history">
            <div class="rentalsmmpanelbd-panel-footer">
                <span class="pull-left">View Details</span>
                <span class="pull-right"><i class="fas fa-arrow-circle-right"></i></span>
                <div class="clearfix"></div>
            </div>
        </a>
    </div>
    
    <!-- Total Categories Panel -->
    <div class="rentalsmmpanelbd-panel">
        <div class="rentalsmmpanelbd-panel-heading">
            <div class="panel-row">
                <div class="panel-icon">
                    <i class="fas fa-layer-group fa-2x" style="color: white;"></i>
                </div>
                <div class="panel-content">
                    <div class="huge"><?php echo countRow(["table"=>"categories","where"=>["category_deleted"=>0]]) ?></div>
                    <h5>Total Categories</h5>
                </div>
            </div>
        </div>
        <a href="/admin/services">
            <div class="rentalsmmpanelbd-panel-footer">
                <span class="pull-left">View Details</span>
                <span class="pull-right"><i class="fas fa-arrow-circle-right"></i></span>
                <div class="clearfix"></div>
            </div>
        </a>
    </div>
    
    <!-- Total Services Panel -->
    <div class="rentalsmmpanelbd-panel">
        <div class="rentalsmmpanelbd-panel-heading">
            <div class="panel-row">
                <div class="panel-icon">
                    <i class="fas fa-cubes fa-2x" style="color: white;"></i>
                </div>
                <div class="panel-content">
                    <div class="huge"><?php echo countRow(["table"=>"services","where"=>["service_deleted"=>0]]) ?></div>
                    <h5>Total Services</h5>
                </div>
            </div>
        </div>
        <a href="/admin/services">
            <div class="rentalsmmpanelbd-panel-footer">
                <span class="pull-left">View Details</span>
                <span class="pull-right"><i class="fas fa-arrow-circle-right"></i></span>
                <div class="clearfix"></div>
            </div>
        </a>
    </div>
    
    <!-- Total Orders with Fake Orders Panel -->
    <div class="rentalsmmpanelbd-panel">
        <div class="rentalsmmpanelbd-panel-heading">
            <div class="panel-row">
                <div class="panel-icon">
                    <i class="fas fa-chart-line fa-2x" style="color: white;"></i>
                </div>
                <div class="panel-content">
                    <div class="huge"><?php echo $settings["panel_orders"]; ?></div>
                    <h5>Total Orders (with fake)</h5>
                </div>
            </div>
        </div>
        <a href="/admin/settings/site_count">
            <div class="rentalsmmpanelbd-panel-footer">
                <span class="pull-left">View Details</span>
                <span class="pull-right"><i class="fas fa-arrow-circle-right"></i></span>
                <div class="clearfix"></div>
            </div>
        </a>
    </div>
    
    <!-- Total Currency Panel -->
    <div class="rentalsmmpanelbd-panel">
        <div class="rentalsmmpanelbd-panel-heading">
            <div class="panel-row">
                <div class="panel-icon">
                    <i class="fas fa-coins fa-2x" style="color: white;"></i>
                </div>
                <div class="panel-content">
                    <div class="huge"><?php echo countRow(["table"=>"currencies","where"=>["is_enable"=>1]]) ?></div>
                    <h5>Total Currency</h5>
                </div>
            </div>
        </div>
        <a href="/admin/settings/site_count">
            <div class="rentalsmmpanelbd-panel-footer">
                <span class="pull-left">View Details</span>
                <span class="pull-right"><i class="fas fa-arrow-circle-right"></i></span>
                <div class="clearfix"></div>
            </div>
        </a>
    </div>
    
    <!-- Total Providers Panel -->
    <div class="rentalsmmpanelbd-panel">
        <div class="rentalsmmpanelbd-panel-heading">
            <div class="panel-row">
                <div class="panel-icon">
                    <i class="fas fa-server fa-2x" style="color: white;"></i>
                </div>
                <div class="panel-content">
                    <div class="huge"><?php echo countRow(["table"=>"service_api"]) ?></div>
                    <h5>Total Providers</h5>
                </div>
            </div>
        </div>
        <a href="/admin/settings/providers">
            <div class="rentalsmmpanelbd-panel-footer">
                <span class="pull-left">View Details</span>
                <span class="pull-right"><i class="fas fa-arrow-circle-right"></i></span>
                <div class="clearfix"></div>
            </div>
        </a>
    </div>
    
    <!-- Total Active Broadcasts Panel -->
    <div class="rentalsmmpanelbd-panel">
        <div class="rentalsmmpanelbd-panel-heading">
            <div class="panel-row">
                <div class="panel-icon">
                    <i class="fas fa-bullhorn fa-2x" style="color: white;"></i>
                </div>
                <div class="panel-content">
                    <div class="huge"><?php echo countRow(["table"=>"notifications_popup","where"=>["status"=>1]]) ?></div>
                    <h5>Active Broadcasts</h5>
                </div>
            </div>
        </div>
        <a href="/admin/broadcasts">
            <div class="rentalsmmpanelbd-panel-footer">
                <span class="pull-left">View Details</span>
                <span class="pull-right"><i class="fas fa-arrow-circle-right"></i></span>
                <div class="clearfix"></div>
            </div>
        </a>
    </div>
    
    
    <!-- Total Staff Panel -->
    <div class="rentalsmmpanelbd-panel">
        <div class="rentalsmmpanelbd-panel-heading">
            <div class="panel-row">
                <div class="panel-icon">
                    <i class="fas fa-user-shield fa-2x" style="color: white;"></i>
                </div>
                <div class="panel-content">
                    <div class="huge">SMM Script</div>
                    <h5></h5>
                </div>
            </div>
        </div>
        <a href="https://rentalsmmpanelbd.com/smm-scripts" target="_blank">
            <div class="rentalsmmpanelbd-panel-footer">
                <span class="pull-left">Click Here</span>
                <span class="pull-right"><i class="fas fa-arrow-circle-right"></i></span>
                <div class="clearfix"></div>
            </div>
        </a>
    </div>
</div>

<div class="modal modal-center fade" id="confirmChange" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static">
   <div class="modal-dialog modal-dialog-center" role="document">
      <div class="modal-content">
         <div class="modal-body text-center">
            <h4>Are you sure you want to proceed?</h4>
            <div align="center">
               <a class="btn btn-primary" href="" id="confirmYes">Yes</a>
               <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
            </div>
         </div>
      </div>
   </div>
</div>

<div class="modal fade" id="modalDiv" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
   <div class="modal-dialog modal-lg" role="document">
     <div class="modal-content">
       <div class="modal-header">
         <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
         <h4 class="modal-title" id="modalTitle"></h4>
       </div>
       <div id="modalContent">
       </div>
     </div>
   </div>
</div>
<?php include 'footer.php'; ?>