<?php
if (!defined('ADDFUNDS')) {
    http_response_code(404);
    die();
}

// 1. Prepare Settings
$apiKey = $methodExtras["api_key"];
$apiUrl = rtrim($methodExtras["api_url"], '/');
$exchangeRate = floatval($methodExtras["exchange_rate"]);
if ($exchangeRate <= 0) $exchangeRate = 1;

$payeeName = $user["name"] ?: "User";
$payeeEmail = $user["email"] ?: "test@test.com";

// 2. Calculate Amount (BDT)
$amountToSend = ceil($paymentAmount * $exchangeRate);

// 3. Generate Order ID
$orderId = md5(RAND_STRING(5) . time()); 

// 4. Prepare Callback URL
// We append order_id so we can identify the user even if PipraPay sends no data
$paymentURL = site_url("payment/" . $methodCallback) . "?order_id=" . $orderId;

// 5. Create Database Record
$insert = $conn->prepare(
    "INSERT INTO payments SET
    client_id=:client_id,
    payment_amount=:amount,
    payment_method=:method,
    payment_mode=:mode,
    payment_create_date=:date,
    payment_ip=:ip,
    payment_extra=:extra"
);

$insert->execute([
    "client_id" => $user["client_id"],
    "amount" => $paymentAmount,
    "method" => $methodId,
    "mode" => "Automatic",
    "date" => date("Y.m.d H:i:s"),
    "ip" => GetIP(),
    "extra" => $orderId
]);

// 6. Prepare API Payload
$requestData = [
    'full_name'     => $payeeName,
    'email_mobile'  => $payeeEmail,
    'amount'        => $amountToSend, 
    'metadata'      => [
        'order_id' => $orderId,
        'user_id'  => $user["client_id"]
    ],
    'redirect_url'  => $paymentURL,
    'cancel_url'    => site_url("addfunds"),
    'webhook_url'   => $paymentURL, 
    'return_type'   => 'POST', // CHANGED TO POST to ensure data is sent
    'currency'      => $methodCurrency 
];

// 7. Send Request
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => $apiUrl . '/create-charge',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_POSTFIELDS => json_encode($requestData),
    CURLOPT_HTTPHEADER => [
        "mh-piprapay-api-key: " . $apiKey,
        "Content-Type: application/json",
        "Accept: application/json"
    ],
]);

$responseRaw = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

// 8. Handle Response
if ($err) {
    errorExit("cURL Error: " . $err);
} else {
    $result = json_decode($responseRaw, true);
    
    if (isset($result['pp_url'])) {
        $response['success'] = true;
        $response['message'] = "Payment initiated. Redirecting...";
        $response['content'] = '<script type="text/javascript">window.location.href="' . $result['pp_url'] . '";</script>';
    } else {
        $msg = isset($result['message']) ? $result['message'] : "Unknown error from PipraPay";
        errorExit($msg);
    }
}
?>