<?php
if (!defined('PAYMENT')) {
    http_response_code(404);
    die();
}

// Helper: Handle Response
function piprapayExit($msg, $isWebhook) {
    if ($isWebhook) {
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'message' => $msg]);
        exit();
    } else {
        header("Location: " . site_url("addfunds?error=" . urlencode($msg)));
        exit();
    }
}

// 1. Retrieve Input Data
$request_data = $_REQUEST;
$input_json = json_decode(file_get_contents('php://input'), true);
if (!empty($input_json)) {
    $request_data = array_merge($request_data, $input_json);
}

// Detect Webhook
$contentType = isset($_SERVER["CONTENT_TYPE"]) ? trim($_SERVER["CONTENT_TYPE"]) : '';
$isWebhook = (strpos($contentType, 'application/json') !== false);

// 2. Find Identifiers
$orderHash = null;
if (isset($request_data['metadata']['order_id'])) $orderHash = $request_data['metadata']['order_id'];
elseif (isset($request_data['order_id'])) $orderHash = $request_data['order_id'];

$pp_id = null;
if (isset($request_data['pp_id'])) $pp_id = $request_data['pp_id'];
elseif (isset($request_data['payment_id'])) $pp_id = $request_data['payment_id'];

// 3. Config
$apiKey = trim($methodExtras['api_key']);
$apiUrl = rtrim(trim($methodExtras['api_url']), '/');

// 4. Initial Check (Prevent Double Payment)
if (!empty($orderHash)) {
    $check = $conn->prepare("SELECT * FROM payments WHERE payment_extra=:orderId");
    $check->execute(["orderId" => $orderHash]);
    $payment = $check->fetch(PDO::FETCH_ASSOC);

    if ($payment) {
        if ($payment['payment_status'] == 3) {
            // Already paid
            if ($isWebhook) { echo json_encode(['success' => true]); exit; }
            header("Location: " . site_url("addfunds?success=true"));
            exit();
        }
    } else {
        piprapayExit("Order Hash not found in Database.", $isWebhook);
    }
}

if (empty($pp_id)) {
    piprapayExit("Transaction Reference (pp_id) missing.", $isWebhook);
}

// 5. Verify with API
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => $apiUrl . '/verify-payments',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_POSTFIELDS => json_encode(['pp_id' => $pp_id]),
    CURLOPT_HTTPHEADER => [
        "mh-piprapay-api-key: " . $apiKey,
        "Content-Type: application/json",
        "Accept: application/json"
    ],
]);

$responseRaw = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

if ($err) {
    piprapayExit("API Verification Connection Error", $isWebhook);
}

$result = json_decode($responseRaw, true);

// 6. Process Result
if (isset($result['status']) && strtolower($result['status']) == 'completed') {
    
    // Recover Order ID
    if (empty($orderHash) && isset($result['metadata']['order_id'])) {
        $orderHash = $result['metadata']['order_id'];
    }

    if (empty($orderHash)) {
        piprapayExit("Order ID missing in API response.", $isWebhook);
    }

    // Fetch Payment Record
    $paymentDetails = $conn->prepare("SELECT * FROM payments WHERE payment_extra=:orderId");
    $paymentDetails->execute(["orderId" => $orderHash]);
    $payment = $paymentDetails->fetch(PDO::FETCH_ASSOC);

    if (!$payment) {
        piprapayExit("Payment record not found.", $isWebhook);
    }

    if ($payment['payment_status'] != 3) {
        
        // Fetch User
        $userDetails = $conn->prepare("SELECT * FROM clients WHERE client_id=:userId");
        $userDetails->execute(["userId" => $payment['client_id']]);
        $user = $userDetails->fetch(PDO::FETCH_ASSOC);

        if (!$user) {
            piprapayExit("User not found.", $isWebhook);
        }

        $paidAmount = floatval($payment["payment_amount"]);
        
        // Fees & Bonuses
        if ($paymentFee > 0) {
            $fee = ($paidAmount * ($paymentFee / 100));
            $paidAmount -= $fee;
        }
        if ($paymentBonusStartAmount != 0 && $paidAmount > $paymentBonusStartAmount) {
            $bonus = $paidAmount * ($paymentBonus / 100);
            $paidAmount += $bonus;
        }

        // FIX: Format Balance to string "0.00" to ensure DB acceptance
        $clientOldBalanceFormatted = number_format((float)$user["balance"], 2, '.', '');

        // 1. Update Payments Table 
        // We added `payment_update_date` just in case the panel sorts by it.
        $updatePayment = $conn->prepare('UPDATE payments SET 
                client_balance=:balance,
                payment_status=:status, 
                payment_delivery=:delivery,
                payment_update_date=:date
                WHERE payment_id=:id');
        
        $updateSuccess = $updatePayment->execute([
            'balance'  => $clientOldBalanceFormatted, 
            'status'   => 3, 
            'delivery' => 2, 
            'date'     => date("Y.m.d H:i:s"),
            'id'       => $payment['payment_id']
        ]);

        if (!$updateSuccess) {
            // Internal error logging if strict SQL fails
            error_log("PipraPay DB Update Failed: " . print_r($updatePayment->errorInfo(), true));
            piprapayExit("Database error during status update.", $isWebhook);
        }

        // 2. Update User Balance
        $new_balance = (float)$user["balance"] + $paidAmount;
        $newBalanceFormatted = number_format($new_balance, 2, '.', '');

        $updateClient = $conn->prepare('UPDATE clients SET balance=:balance WHERE client_id=:id');
        $updateClient->execute([
            "balance" => $newBalanceFormatted,
            "id" => $user["client_id"]
        ]);

        if ($isWebhook) {
            echo json_encode(['success' => true, 'message' => 'Processed']);
        } else {
            header("Location: " . site_url("addfunds?success=true"));
        }
        exit();

    } else {
        // Already paid
        if ($isWebhook) {
            echo json_encode(['success' => true, 'message' => 'Already Processed']);
        } else {
            header("Location: " . site_url("addfunds?success=true"));
        }
        exit();
    }

} else {
    // Payment Failed/Pending
    $msg = isset($result['message']) ? $result['message'] : "Payment status is " . ($result['status'] ?? 'Unknown');
    piprapayExit($msg, $isWebhook);
}
?>